#include <utility>
#include <algorithm>
#include <iostream>
#include <stack>
#include <vector>

using namespace std;

struct triple {
    int first;
    int second;
    int third;
};
//za dzeka vrabca ni smrt nije dovoljna kazna
bool poredjenje(triple a, triple b) {
    return a.first < b.first;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    if (!(cin >> n)) return 0;


    int a[n], b[n];
    triple q[n];

    for (int i = 0; i < n; i++) cin >> a[i];
    for (int i = 0; i < n; i++) cin >> b[i];

    for (int i = 0; i < n; i++) {
        q[i].first = a[i];
        q[i].second = b[i];
        q[i].third = i;
    }


    sort(q, q+n, poredjenje);

    vector<int> l(n, -1);
    vector<int> d(n, -1);
    stack<int> stek;


    for (int i = 0; i < n; i++) {

        while (!stek.empty() && q[stek.top()].second < q[i].second)
            stek.pop();

        if (!stek.empty())
            l[i] = stek.top();

        stek.push(i);
    }

    while (!stek.empty()) stek.pop();


    for (int i = n - 1; i >= 0; i--) {
        while (!stek.empty() && q[stek.top()].second < q[i].second)
            stek.pop();

        if (!stek.empty())
            d[i] = stek.top();

        stek.push(i);
    }


    int resenja[n];

    for (int i = 0; i < n; i++) {
        int ll = -67;
        int dd = -67;


        if (l[i] != -1) {
            int k = l[i];
            ll = (q[i].first + q[i].second) - (q[k].first + q[k].second);
        }


        if (d[i] != -1) {
            int j = d[i];
            dd = q[j].first - q[j].second - q[i].first + q[i].second;
        }

        int res = -67;

        if (ll == -67 && dd == -67) {
            res = -1;
        } else if (ll == -67) {
            res = dd;
        } else if (dd == -67) {
            res = ll;
        } else {
            res = min(ll, dd);
        }


        resenja[q[i].third] = res;
    }


    for (int i = 0; i < n; i++) {
        cout << resenja[i] << endl;
    }

    return 0;
}